(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     74306,       2113]
NotebookOptionsPosition[     67575,       1986]
NotebookOutlinePosition[     67971,       2002]
CellTagsIndexPosition[     67928,       1999]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], " ", "=", " ", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", " ", "d", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
        RowBox[{"2", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", " ", 
        SuperscriptBox["h", "\[Alpha]"]}], "-", 
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", 
     SuperscriptBox["y", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "d", " ", "r"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
    RowBox[{"2", " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}]], 
   RowBox[{"(*", 
    RowBox[{"F1", 
     RowBox[{"(", 
      RowBox[{"X", ",", "Y"}], ")"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{
  3.9736790386597633`*^9, {3.9736795970968018`*^9, 3.9736796123735676`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"7967d68e-8880-fd47-a4fa-abedda8f94b4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "d", " ", "r"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
    RowBox[{"2", " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", 
    SuperscriptBox["y", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "d", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
       ")"}]}]]}]]}]], "Output",
 CellChangeTimes->{3.9736791013572807`*^9, 3.9736796514140835`*^9, 
  3.973679693241705*^9, 3.9736797482670746`*^9, 3.973680436396553*^9, 
  3.9739174591825256`*^9, 3.9739176111095066`*^9, 3.974016742164507*^9},
 CellLabel->"Out[2]=",ExpressionUUID->"d1f18ad1-f593-8540-b7c1-908b6110c593"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], " ", "=", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"d", " ", 
         SuperscriptBox["h", "\[Alpha]"]}], "-", 
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", 
      SuperscriptBox["y", "2"]}], 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}]}], "-", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}]}], "-", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]], 
   RowBox[{"(*", 
    RowBox[{"F2", 
     RowBox[{"(", 
      RowBox[{"X", ",", "Y"}], ")"}]}], "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.9736796219559193`*^9, 3.973679625381464*^9}, {
  3.9736796794441624`*^9, 3.9736796805086994`*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"66ed9c86-d75a-374a-b007-dfee4e0a1150"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", " ", 
        SuperscriptBox["h", "\[Alpha]"]}], "-", 
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", 
     SuperscriptBox["y", "2"]}], 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}]}], "-", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", "y", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{
  3.9736791225151463`*^9, {3.9736796291582127`*^9, 3.9736796515664883`*^9}, 
   3.973679693384941*^9, 3.973679748394781*^9, 3.973680436546444*^9, 
   3.973917471773424*^9, 3.9739176112095985`*^9, 3.9740167423204327`*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"fd255552-fb0a-1946-b163-0d05f8bb05ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fx", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",ExpressionUUID->"6b3fc5ca-0acb-6b4a-a400-448b6d644475"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "d", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.9736791739736767`*^9, 3.973679651573488*^9, 
  3.973679693406933*^9, 3.973679748413784*^9, 3.9736804365676556`*^9, 
  3.97391751000675*^9, 3.9739176112265644`*^9, 3.97401674235227*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"8296ab8b-601a-f047-891a-fcdb53cdfb47"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fxx", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fx", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",ExpressionUUID->"838ef9ea-2cdb-554c-ad31-ad4a68316dc2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.973679188953745*^9, 3.9736796516032352`*^9, 
  3.9736796934129276`*^9, 3.97367974843379*^9, 3.9736804365897446`*^9, 
  3.97391751175955*^9, 3.9739176112325745`*^9, 3.974016742384033*^9},
 CellLabel->"Out[5]=",ExpressionUUID->"ad15c3c8-9e5b-1e43-9c04-4f6a53d2e697"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fxxx", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fxx", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",ExpressionUUID->"84464924-631e-4949-b12a-d646cfe602b1"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9736792237390976`*^9, 3.973679651628128*^9, 
  3.973679693432482*^9, 3.973679748454115*^9, 3.973680436596756*^9, 
  3.973917513028076*^9, 3.9739176112394733`*^9, 3.9740167424156055`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"8921e395-64a6-bf40-b79e-7bb995c7eb39"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[7]:=",ExpressionUUID->"ab741695-d403-f245-a2a1-36303938e1c2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "d", " ", "r"}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
    RowBox[{"2", " ", "r", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", "y", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "d", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
       ")"}]}]]}]]}]], "Output",
 CellChangeTimes->{3.973679233396515*^9, 3.973679651634863*^9, 
  3.9736796934566936`*^9, 3.9736797484768696`*^9, 3.973680436604748*^9, 
  3.9739175146674843`*^9, 3.9739176112566223`*^9, 3.9740167424511223`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"ec746362-c572-5f48-9b1c-10789eee1f6f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fyy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fy", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[8]:=",ExpressionUUID->"1a9aed5c-b742-2745-a48e-b8ceb295550a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "d", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
   RowBox[{"r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
       ")"}]}]]}]]}]], "Output",
 CellChangeTimes->{3.973679244309717*^9, 3.973679651661312*^9, 
  3.9736796934642563`*^9, 3.9736797484969826`*^9, 3.9736804366267624`*^9, 
  3.9739175164017277`*^9, 3.973917611274391*^9, 3.974016742482107*^9},
 CellLabel->"Out[8]=",ExpressionUUID->"2a4f1c62-81f2-0346-950e-8c1eb6375796"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fyyy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fyy", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",ExpressionUUID->"efad3939-bad5-b945-afd4-3e86e2e94df8"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9736792573630333`*^9, 3.9736796516673145`*^9, 
  3.9736796934860134`*^9, 3.9736797485161934`*^9, 3.9736804366337624`*^9, 
  3.973917518309738*^9, 3.9739176112802906`*^9, 3.9740167425093975`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"c509ed2e-e953-d54f-8781-310e352cbdf3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fxy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fx", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[10]:=",ExpressionUUID->"69f49ff9-e417-5f40-aeaa-cde257593c69"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"2", " ", "d", " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
      RowBox[{"2", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]}], ")"}]}], 
   RowBox[{"2", " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]}]], "Output",
 CellChangeTimes->{3.9736792711762466`*^9, 3.973679651688341*^9, 
  3.9736796935057774`*^9, 3.9736797485228214`*^9, 3.973680436656641*^9, 
  3.9739175198905106`*^9, 3.9739176112863846`*^9, 3.9740167425573006`*^9},
 CellLabel->"Out[10]=",ExpressionUUID->"4c29179c-a03b-314a-ab90-fac7fe908389"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fxyy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fxy", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[11]:=",ExpressionUUID->"5b65a73c-4e20-c742-b9f2-fcd063f2c2ce"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.973679290275976*^9, 3.9736796516958885`*^9, 
  3.9736796935267715`*^9, 3.9736797485400295`*^9, 3.9736804366626434`*^9, 
  3.973917521578575*^9, 3.9739176113063107`*^9, 3.974016742606552*^9},
 CellLabel->"Out[11]=",ExpressionUUID->"c451d916-cbde-6d4c-8e06-aa7632e88e18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fxxy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"fxx", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[12]:=",ExpressionUUID->"63c22187-6a1e-7a49-aba3-25212eb88839"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.973679300385994*^9, 3.973679651715887*^9, 
  3.9736796935492516`*^9, 3.9736797485591793`*^9, 3.973680436685549*^9, 
  3.9739175230124836`*^9, 3.9739176113123207`*^9, 3.9740167426583405`*^9},
 CellLabel->"Out[12]=",ExpressionUUID->"43342e35-8eca-8d44-843b-c4944ffdbfaa"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gx", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.973679719281702*^9, 3.9736797202373047`*^9}},
 CellLabel->"In[13]:=",ExpressionUUID->"f5a3b55e-e3f9-ec46-bb2d-a2e4f837855a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "y", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.9736793201118813`*^9, 3.973679651722889*^9, 
  3.973679693569441*^9, 3.973679748579132*^9, 3.9736804366926537`*^9, 
  3.973917524222904*^9, 3.9739176113283577`*^9, 3.974016742668455*^9},
 CellLabel->"Out[13]=",ExpressionUUID->"5e791f14-3628-c840-9d26-67c824d03db0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gxx", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gx", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{3.973679723367132*^9},
 CellLabel->"In[14]:=",ExpressionUUID->"e1ae5c23-652e-724c-9ada-3cc1194223b2"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.973679330565346*^9, 3.973679651729891*^9, 
  3.973679693590336*^9, 3.973679748585127*^9, 3.9736804367165413`*^9, 
  3.973917525961014*^9, 3.9739176113453503`*^9, 3.974016742718338*^9},
 CellLabel->"Out[14]=",ExpressionUUID->"e990d9d4-7ba3-2e4a-90f4-7349988ee597"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gxxx", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gxx", ",", "x"}], "]"}]}]], "Input",
 CellChangeTimes->{3.973679729649872*^9},
 CellLabel->"In[15]:=",ExpressionUUID->"6352e0aa-11cc-434c-bb09-5c1cc20a4ffd"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9736793428445625`*^9, 3.9736796517513676`*^9, 
  3.9736796936105595`*^9, 3.9736797486039467`*^9, 3.9736804367235527`*^9, 
  3.973917528457098*^9, 3.973917611362316*^9, 3.9740167427708073`*^9},
 CellLabel->"Out[15]=",ExpressionUUID->"4abf4d8b-065d-934b-b2c9-1a24be40c0ca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}]}]], "Input",
 CellChangeTimes->{3.97367973217029*^9},
 CellLabel->"In[16]:=",ExpressionUUID->"f107e166-6cd9-464e-b7a4-0389d2d34972"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", " ", 
        SuperscriptBox["h", "\[Alpha]"]}], "-", 
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}], " ", "y"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}]}], "-", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", "x", " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.9736793529614143`*^9, 3.973679651759371*^9, 
  3.9736796936174374`*^9, 3.9736797486249638`*^9, 3.97368043674506*^9, 
  3.9739175299870815`*^9, 3.9739176113788357`*^9, 3.974016742780716*^9},
 CellLabel->"Out[16]=",ExpressionUUID->"ac902ac7-3f92-0542-8ac0-58b7440cd1fd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gyy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gy", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[17]:=",ExpressionUUID->"c45a4a22-e098-1241-86e1-07802703052d"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"d", " ", 
       SuperscriptBox["h", "\[Alpha]"]}], "-", 
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", "r"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.9736793643500633`*^9, 3.973679651781006*^9, 
  3.9736796936354523`*^9, 3.973679748631956*^9, 3.973680436769417*^9, 
  3.9739175318524456`*^9, 3.973917611395052*^9, 3.974016742806858*^9},
 CellLabel->"Out[17]=",ExpressionUUID->"a38318a5-be7a-0640-9793-6e17f2265a18"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gyyy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gyy", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[18]:=",ExpressionUUID->"0d138635-0090-174d-815b-542bf2e0d8b5"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9736793761637*^9, 3.9736796517870045`*^9, 
  3.97367969365485*^9, 3.973679748655382*^9, 3.9736804367762985`*^9, 
  3.973917534262039*^9, 3.973917611412628*^9, 3.9740167428354263`*^9},
 CellLabel->"Out[18]=",ExpressionUUID->"b171a312-2406-4e44-b07f-85064479f845"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gxy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gx", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[19]:=",ExpressionUUID->"d3d2c617-cd76-da49-a607-2928471f9489"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["h", "\[Alpha]"], " ", 
    SqrtBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
        RowBox[{"4", " ", "r", " ", 
         SuperscriptBox[
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}]]}]], "Output",
 CellChangeTimes->{3.9736793890353966`*^9, 3.9736796518082447`*^9, 
  3.973679698228115*^9, 3.973679753897049*^9, 3.973680436798296*^9, 
  3.973917535962509*^9, 3.973917611428568*^9, 3.974016742865078*^9},
 CellLabel->"Out[19]=",ExpressionUUID->"f35f45e7-d47f-7648-b7a6-ec95f1ca46a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gxyy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gxy", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[20]:=",ExpressionUUID->"2f1a8c86-b3a2-d342-8bb5-6598276f92d9"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9736794005366344`*^9, 3.973679651830248*^9, 
  3.9736796986742973`*^9, 3.973679754314152*^9, 3.973680450016119*^9, 
  3.9739175375793705`*^9, 3.9739176114345875`*^9, 3.9740167428721886`*^9},
 CellLabel->"Out[20]=",ExpressionUUID->"016bbc9d-bed3-bc46-87ef-9b4fc39e9dd7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gxxy", " ", "=", " ", 
  RowBox[{"D", "[", 
   RowBox[{"gxx", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[21]:=",ExpressionUUID->"caac1b25-d9ce-834d-8f12-9deda92a459a"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.9736794129002247`*^9, 3.97367965183634*^9, 
  3.9736796986812973`*^9, 3.9736797543451557`*^9, 3.9736804523364925`*^9, 
  3.9739175389890633`*^9, 3.973917611442995*^9, 3.974016742900528*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"0ffdcb27-65b6-1e4a-a073-3e2372f09321"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"al", "=", 
  RowBox[{"(", 
   FractionBox[
    RowBox[{
     RowBox[{"d", " ", 
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
     RowBox[{"2", " ", "d", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["h", "\[Alpha]"], " ", 
      SuperscriptBox["r", "2"], " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
     RowBox[{"2", " ", "r", " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
    RowBox[{"(", 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "d"}], " ", 
         SuperscriptBox["h", "\[Alpha]"]}], "+", 
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "+", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}], ")"}]], ")"}], 
  RowBox[{"(*", 
   RowBox[{"real", " ", "part", " ", "of", " ", "the", " ", "eigenvalue"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.973679519133156*^9, 3.9736795723778057`*^9}},
 CellLabel->"In[22]:=",ExpressionUUID->"e28adfce-ce47-2046-a1f6-b9e153246392"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"d", " ", 
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
   RowBox[{"2", " ", "d", " ", 
    SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["h", "\[Alpha]"], " ", 
    SuperscriptBox["r", "2"], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
   RowBox[{"2", " ", "r", " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], 
  RowBox[{"2", " ", "r", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "d"}], " ", 
      SuperscriptBox["h", "\[Alpha]"]}], "+", 
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "+", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.9736794965861187`*^9, 3.9736796518615475`*^9, 
  3.9736796987073*^9, 3.973679754378687*^9, 3.9736804524142685`*^9, 
  3.9739175416117783`*^9, 3.9739176114604263`*^9, 3.974016742929348*^9},
 CellLabel->"Out[22]=",ExpressionUUID->"cff4d5f9-0644-6f49-8638-267c64e73565"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"be", "=", 
  RowBox[{"(", 
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"d", " ", 
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
         RowBox[{"4", " ", "d", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["h", "\[Alpha]"], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
         RowBox[{"4", " ", "r", " ", 
          SuperscriptBox[
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
    RowBox[{"(", 
     RowBox[{"2", " ", "r", " ", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "d"}], " ", 
         SuperscriptBox["h", "\[Alpha]"]}], "+", 
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "+", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}], ")"}]], ")"}], 
  RowBox[{"(*", 
   RowBox[{
   "imaginary", " ", "part", " ", "of", " ", "the", " ", "eigenvalue"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{
  3.9736795132358074`*^9, {3.9736795798910503`*^9, 3.973679586123493*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"a26730d5-8c09-5440-95e3-bce0ec0567d2"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "\[Alpha]"], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"d", " ", 
        SuperscriptBox["h", 
         RowBox[{"2", " ", "\[Alpha]"}]]}], "-", 
       RowBox[{
        SuperscriptBox["h", 
         RowBox[{"2", " ", "\[Alpha]"}]], " ", "r"}], "-", 
       RowBox[{"4", " ", "d", " ", 
        SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["h", "\[Alpha]"], " ", 
        SuperscriptBox["r", "2"], " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
       RowBox[{"4", " ", "r", " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]]}], 
  RowBox[{"2", " ", "r", " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "d"}], " ", 
      SuperscriptBox["h", "\[Alpha]"]}], "+", 
     RowBox[{
      SuperscriptBox["h", "\[Alpha]"], " ", "r"}], "+", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.9736795157354393`*^9, 3.9736795893943577`*^9, 
  3.973679656623995*^9, 3.973679698730297*^9, 3.973679754415209*^9, 
  3.9736804524837704`*^9, 3.973917543902586*^9, 3.973917611467367*^9, 
  3.9740167429577885`*^9},
 CellLabel->"Out[23]=",ExpressionUUID->"30848a4a-9787-9c46-a0db-dc7f35af5189"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t1", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"32", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "al"}], ")"}], "2"], "+", 
        SuperscriptBox["be", "2"]}], ")"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["al", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["fxx", "2"], "-", 
         SuperscriptBox["fyy", "2"], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"fxx", "+", "fyy"}], ")"}], " ", "gxy"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fxy"}], "-", "gxx", "+", "gyy"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["al", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["fxx", "2"]}], "-", 
         RowBox[{"3", " ", "fyy", " ", 
          RowBox[{"(", 
           RowBox[{"fyy", "-", 
            RowBox[{"2", " ", "gxy"}]}], ")"}]}], "+", 
         RowBox[{"fxx", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"8", " ", "be", " ", 
             RowBox[{"(", 
              RowBox[{"fxy", "-", "gxx"}], ")"}]}], "+", 
            RowBox[{"6", " ", "gxy"}]}], ")"}]}], "+", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fxy"}], "-", "gxx", "+", "gyy"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"gxx", "+", "gyy"}], ")"}]}], "+", 
         RowBox[{"8", " ", "be", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"fxy", " ", "fyy"}], "+", 
            RowBox[{"fyy", " ", "gyy"}], "-", 
            RowBox[{"gxy", " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["al", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["fxx", "2"], "-", 
         RowBox[{"fyy", " ", 
          RowBox[{"(", 
           RowBox[{"fyy", "-", 
            RowBox[{"2", " ", "gxy"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "fxx", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", "be", " ", 
             RowBox[{"(", 
              RowBox[{"fxy", "-", "gxx"}], ")"}]}], "+", "gxy"}], ")"}]}], 
         "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fxy"}], "-", "gxx", "+", "gyy"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"gxx", "+", "gyy"}], ")"}]}], "+", 
         RowBox[{"10", " ", "be", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"fxy", " ", "fyy"}], "+", 
            RowBox[{"fyy", " ", "gyy"}], "-", 
            RowBox[{"gxy", " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["be", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["be", "2"]}]}], ")"}], " ", 
          SuperscriptBox["fxx", "2"]}], "-", 
         RowBox[{"fyy", " ", 
          RowBox[{"(", 
           RowBox[{"fyy", "-", 
            RowBox[{"2", " ", "gxy"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", "fxx", " ", 
          RowBox[{"(", 
           RowBox[{"gxy", "+", 
            RowBox[{"be", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "fxy"}], "+", "gxx", "+", 
               RowBox[{"2", " ", "be", " ", "gxy"}]}], ")"}]}]}], ")"}]}], 
         "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "fxy"}], "-", "gxx", "+", "gyy"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"gxx", "+", "gyy"}], ")"}]}], "+", 
         RowBox[{"2", " ", "be", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "fxy"}], " ", "fyy"}], "-", 
            RowBox[{"fyy", " ", "gyy"}], "+", 
            RowBox[{"gxy", " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["be", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["fyy", "2"]}], "+", 
            RowBox[{"2", " ", "fyy", " ", "gxy"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "fxy"}], "-", "gxx", "+", "gyy"}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{"al", " ", "be", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "fxy"}], " ", "fyy"}], "+", 
            RowBox[{"fxx", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "fxy"}], "+", "gxx"}], ")"}]}], "-", 
            RowBox[{"fyy", " ", "gyy"}], "+", 
            RowBox[{"gxy", " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["be", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "fxy"}], " ", "fyy"}], "+", 
            RowBox[{"fxx", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "fxy"}], "+", "gxx"}], ")"}]}], "-", 
            RowBox[{"fyy", " ", "gyy"}], "+", 
            RowBox[{"gxy", " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"be", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["fxx", "2"], "-", 
            SuperscriptBox["fyy", "2"], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"fxx", "+", "fyy"}], ")"}], " ", "gxy"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "fxy"}], "-", "gxx", "+", "gyy"}], ")"}], 
             " ", 
             RowBox[{"(", 
              RowBox[{"gxx", "+", "gyy"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
     ")"}]}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
   "compute", " ", "the", " ", "first", " ", "term", " ", "of", " ", "k", " ",
     "which", " ", "is", " ", 
    RowBox[{"Re", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[Lambda]"}]}], ")"}], " ", 
      RowBox[{
       RowBox[{
        RowBox[{"Conjugate", "[", "\[Lambda]", "]"}], "^", "2"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Lambda]"}], ")"}]}], "*", "\[Xi]11", "*", 
      "\[Xi]20"}], "]"}]}], "\n", "*)"}]}]], "Input",
 CellChangeTimes->{{3.973679891724909*^9, 3.9736798954182854`*^9}, {
   3.9736803426633987`*^9, 3.973680413481571*^9}, {3.973680489078106*^9, 
   3.9736805976795273`*^9}, {3.97368062994602*^9, 3.973680659943775*^9}, 
   3.9736806915200615`*^9},
 CellLabel->"In[24]:=",ExpressionUUID->"ebdd3e99-f4d0-124a-9dca-6b385b8b06c2"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["h", 
       RowBox[{"2", " ", "\[Alpha]"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"6", " ", "\[Alpha]"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], "3"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"d", " ", "r"}], "+", 
            SuperscriptBox["r", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{"r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["h", 
             RowBox[{"5", " ", "\[Alpha]"}]], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"d", "-", "r"}], ")"}], "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"d", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"Gamma", "[", 
             RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", 
               SuperscriptBox["h", 
                RowBox[{"4", " ", "\[Alpha]"}]], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"d", "-", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "2"}], "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], 
                "2"]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", 
                  SuperscriptBox["h", 
                   RowBox[{"3", " ", "\[Alpha]"}]], " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"d", "-", "r"}], ")"}], "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"2", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "5"}], "+", 
                    RowBox[{"4", " ", 
                    RowBox[{"(", 
                    RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}]}]}], 
                   ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["h", 
                   RowBox[{"2", " ", "\[Alpha]"}]], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"d", "-", "r"}], ")"}], " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"6", " ", 
                    RowBox[{"(", 
                    RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}]}]}], 
                   ")"}], " ", 
                  RowBox[{"Gamma", "[", 
                   RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "+", 
                 RowBox[{"4", " ", 
                  SuperscriptBox["h", "\[Alpha]"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    RowBox[{"2", " ", "r", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "d"}], "+", "r"}], ")"}]}]}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"Gamma", "[", 
                    RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", "1"}], "-", 
                    RowBox[{"d", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}], " ", 
                  SuperscriptBox[
                   RowBox[{"Gamma", "[", 
                    RowBox[{"1", "+", "\[Alpha]"}], "]"}], "3"]}]}], 
                ")"}]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"8", " ", 
      RowBox[{"(", 
       RowBox[{"d", "-", "r"}], ")"}], " ", 
      SuperscriptBox["r", "3"], " ", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", 
          RowBox[{"2", " ", "\[Alpha]"}]], " ", 
         RowBox[{"(", 
          RowBox[{"d", "-", "r"}], ")"}]}], "+", 
        RowBox[{"4", " ", "r", " ", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["h", "\[Alpha]"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]}], ")"}]}], 
     ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.9736806394247227`*^9, 3.9736806936216583`*^9}, 
   3.973917561378874*^9, 3.973917622646164*^9, 3.974016756906826*^9},
 CellLabel->"Out[24]=",ExpressionUUID->"880f5c8f-f805-e24f-a1e3-9e24220704a7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t2", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"fxx", "+", "fyy"}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"gxx", " ", "+", " ", "gyy"}], ")"}], "^", "2"}]}], ")"}], 
   "]"}], 
  RowBox[{"(*", 
   RowBox[{
   "to", " ", "compute", " ", "the", " ", "second", " ", "term", " ", "of", 
    " ", "k"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.9736806970689144`*^9, 3.973680744152912*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"c8238ef6-1fbd-db45-b033-c465b50dd89a"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["h", 
     RowBox[{"4", " ", "\[Alpha]"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"d", " ", "r"}], "+", 
      SuperscriptBox["r", "2"]}], ")"}]}], 
   RowBox[{"r", " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        RowBox[{"2", " ", "\[Alpha]"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "-", 
      RowBox[{"4", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]}], 
     ")"}]}]]}]], "Output",
 CellChangeTimes->{3.973680722486601*^9, 3.9739176233253784`*^9, 
  3.9740167573340015`*^9},
 CellLabel->"Out[25]=",ExpressionUUID->"9918eb96-e3ea-7944-8607-c85182556397"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3", " ", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"fxx", "-", "fyy", "-", 
        RowBox[{"2", "gxy"}]}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"gxx", " ", "-", "gyy", " ", "+", 
        RowBox[{"2", "fxy"}]}], ")"}], "^", "2"}]}], ")"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "to", " ", "compute", " ", "the", " ", "third", " ", "term", " ", "of", 
     " ", "k"}], ",", " ", 
    RowBox[{
    "the", " ", "fourth", " ", "term", " ", "will", " ", "equal", " ", "zero",
      " ", "so", " ", "no", " ", "need", " ", "to", " ", "compute", " ", "it",
      " ", "in", " ", "my", " ", "case"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.973680746952482*^9, 3.973680767491846*^9}, {
  3.9736808988056736`*^9, 3.9736809472860622`*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"297dea56-ac21-b249-8f6a-ebd0e00873dd"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", "\[Alpha]"], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "-", 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"d", "-", "r"}], ")"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        RowBox[{"2", " ", "\[Alpha]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}]}], "+", 
      RowBox[{"4", " ", "r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", "\[Alpha]"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{"Gamma", "[", 
          RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}]}]}], 
     ")"}]}]]}]], "Output",
 CellChangeTimes->{3.973680951305092*^9, 3.9739176239033566`*^9, 
  3.9740167576493397`*^9},
 CellLabel->"Out[26]=",ExpressionUUID->"0d4b4243-79eb-f740-94bd-ea664381f811"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Now", ",", " ", 
   RowBox[{"we", " ", "compute", " ", "k"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.973680955485716*^9, 3.9736809690798225`*^9}},
 CellLabel->"In[27]:=",ExpressionUUID->"91d8950c-1517-2441-a740-2d7ab9377ce9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", " ", "=", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{"-", "t1"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "32"}], ")"}], "*", "t2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "/", "64"}], ")"}], "*", "t3"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.9736809939894047`*^9, 3.973681013539221*^9}, {
  3.9737433013730087`*^9, 3.973743301809841*^9}},
 CellLabel->"In[28]:=",ExpressionUUID->"378b8eee-0bbd-8843-84fa-c7d0d426dcf7"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["h", 
     RowBox[{"2", " ", "\[Alpha]"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["h", 
        RowBox[{"4", " ", "\[Alpha]"}]], " ", 
       RowBox[{"(", 
        RowBox[{"d", "-", "r"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"d", " ", "r"}], "+", 
          SuperscriptBox["r", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"r", " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SuperscriptBox["h", 
           RowBox[{"3", " ", "\[Alpha]"}]], " ", 
          RowBox[{"(", 
           RowBox[{"d", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "2"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"r", " ", 
          RowBox[{"Gamma", "[", 
           RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", 
             SuperscriptBox["h", 
              RowBox[{"2", " ", "\[Alpha]"}]], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"d", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["h", "\[Alpha]"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               RowBox[{"3", " ", 
                RowBox[{"(", 
                 RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], " ", 
             RowBox[{"Gamma", "[", 
              RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"Gamma", "[", 
               RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]}], 
        ")"}]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"8", " ", 
    SuperscriptBox["r", "3"], " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", "\[Alpha]"}], "]"}], "3"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", "\[Alpha]"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], "3"]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{3.973681020402687*^9, 3.973917628443817*^9, 
  3.9740167608417645`*^9},
 CellLabel->"Out[28]=",ExpressionUUID->"15c274a4-85fb-894d-a1e9-c1354a48b468"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"for", " ", "example", " ", "take", " ", "r"}], " ", "=", " ", 
     "2"}], ",", " ", 
    RowBox[{"d", " ", "=", " ", "0.2"}], " ", ",", " ", 
    RowBox[{"alpha", " ", "=", " ", "0.95"}], ",", " ", 
    RowBox[{"h", " ", "=", " ", "0.3"}], " ", ",", " ", "then"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox[
    RowBox[{
     SuperscriptBox["h", "\[Alpha]"], " "}], 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", "\[Alpha]"}], "]"}]], "/.", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"h", "->", "0.5"}], ",", 
     RowBox[{"\[Alpha]", "->", "0.95"}]}], "}"}]}]}]], "Input",
 CellChangeTimes->{{3.973917684835182*^9, 3.973917714963743*^9}, {
   3.9739177832301846`*^9, 3.973917818067339*^9}, 
   3.974016765347809*^9},ExpressionUUID->"03046767-2cc8-6a43-8268-\
6d419f701000"],

Cell[BoxData["0.5282607236385721`"], "Output",
 CellChangeTimes->{3.973917820208311*^9, 3.974016760893156*^9},
 CellLabel->"Out[29]=",ExpressionUUID->"468ea046-6006-ed40-a549-e5d6e3527027"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
  "greater", " ", "than", " ", "zero", " ", "and", " ", "less", " ", "than", 
   " ", "or", " ", "equal", " ", "to", " ", "2", "r", " ", "which", " ", "is",
    " ", "4"}], "*)"}]], "Input",
 CellChangeTimes->{{3.973917826880966*^9, 3.9739178424373074`*^9}},
 CellLabel->"In[30]:=",ExpressionUUID->"bdab453d-5880-5a4c-8429-ed5780015fd2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["h", 
      RowBox[{"2", " ", "\[Alpha]"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox["h", 
         RowBox[{"4", " ", "\[Alpha]"}]], " ", 
        RowBox[{"(", 
         RowBox[{"d", "-", "r"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"d", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], "2"]}], "+", 
       RowBox[{"r", " ", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["h", 
            RowBox[{"3", " ", "\[Alpha]"}]], " ", 
           RowBox[{"(", 
            RowBox[{"d", "-", "r"}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "2"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
          RowBox[{"r", " ", 
           RowBox[{"Gamma", "[", 
            RowBox[{"1", "+", "\[Alpha]"}], "]"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", 
              SuperscriptBox["h", 
               RowBox[{"2", " ", "\[Alpha]"}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "d"}], "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"1", "-", 
                RowBox[{"d", " ", "r"}], "+", 
                SuperscriptBox["r", "2"]}], ")"}]}], "+", 
             RowBox[{
              SuperscriptBox["h", "\[Alpha]"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                RowBox[{"3", " ", 
                 RowBox[{"(", 
                  RowBox[{"d", "-", "r"}], ")"}], " ", "r"}]}], ")"}], " ", 
              RowBox[{"Gamma", "[", 
               RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], "-", 
             RowBox[{"r", " ", 
              SuperscriptBox[
               RowBox[{"Gamma", "[", 
                RowBox[{"1", "+", "\[Alpha]"}], "]"}], "2"]}]}], ")"}]}]}], 
         ")"}]}]}], ")"}]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"8", " ", 
     SuperscriptBox["r", "3"], " ", 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", "\[Alpha]"}], "]"}], "3"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["h", "\[Alpha]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "d"}], "+", "r"}], ")"}]}], "+", 
        RowBox[{"Gamma", "[", 
         RowBox[{"1", "+", "\[Alpha]"}], "]"}]}], ")"}], "3"]}], ")"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r", "->", "2"}], ",", 
    RowBox[{"d", "->", "0.2"}], ",", 
    RowBox[{"h", "->", "0.3"}], ",", 
    RowBox[{"\[Alpha]", "->", "0.95"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.9739177258181896`*^9, 3.9739177259954967`*^9}, {
  3.973917858487732*^9, 3.9739178687565975`*^9}, {3.9740166876763954`*^9, 
  3.974016712472187*^9}},
 CellLabel->"In[31]:=",ExpressionUUID->"bb72b347-4758-2545-9ba5-17d7176112ca"],

Cell[BoxData[
 RowBox[{"-", "0.015535467576965084`"}]], "Output",
 CellChangeTimes->{3.9739178717321224`*^9, 3.9740166947744083`*^9, 
  3.9740167609261284`*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"11a4973a-cee7-9b4d-9195-1081fceb2571"]
}, Open  ]]
},
WindowSize->{949, 521},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"14.1 for Microsoft Windows (64-bit) (July 16, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"7076970d-f7c0-df45-ba56-70c84faa7f99"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 3226, 95, 130, "Input",ExpressionUUID->"7967d68e-8880-fd47-a4fa-abedda8f94b4"],
Cell[3805, 119, 3074, 90, 106, "Output",ExpressionUUID->"d1f18ad1-f593-8540-b7c1-908b6110c593"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6916, 214, 2485, 73, 101, "Input",ExpressionUUID->"66ed9c86-d75a-374a-b007-dfee4e0a1150"],
Cell[9404, 289, 2357, 68, 56, "Output",ExpressionUUID->"fd255552-fb0a-1946-b163-0d05f8bb05ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11798, 362, 246, 6, 28, "Input",ExpressionUUID->"6b3fc5ca-0acb-6b4a-a400-448b6d644475"],
Cell[12047, 370, 1188, 32, 53, "Output",ExpressionUUID->"8296ab8b-601a-f047-891a-fcdb53cdfb47"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13272, 407, 192, 4, 28, "Input",ExpressionUUID->"838ef9ea-2cdb-554c-ad31-ad4a68316dc2"],
Cell[13467, 413, 314, 4, 32, "Output",ExpressionUUID->"ad15c3c8-9e5b-1e43-9c04-4f6a53d2e697"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13818, 422, 194, 4, 28, "Input",ExpressionUUID->"84464924-631e-4949-b12a-d646cfe602b1"],
Cell[14015, 428, 314, 4, 32, "Output",ExpressionUUID->"8921e395-64a6-bf40-b79e-7bb995c7eb39"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14366, 437, 246, 6, 28, "Input",ExpressionUUID->"ab741695-d403-f245-a2a1-36303938e1c2"],
Cell[14615, 445, 3028, 89, 106, "Output",ExpressionUUID->"ec746362-c572-5f48-9b1c-10789eee1f6f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17680, 539, 192, 4, 28, "Input",ExpressionUUID->"1a9aed5c-b742-2745-a48e-b8ceb295550a"],
Cell[17875, 545, 2107, 61, 60, "Output",ExpressionUUID->"2a4f1c62-81f2-0346-950e-8c1eb6375796"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20019, 611, 194, 4, 28, "Input",ExpressionUUID->"efad3939-bad5-b945-afd4-3e86e2e94df8"],
Cell[20216, 617, 322, 4, 32, "Output",ExpressionUUID->"c509ed2e-e953-d54f-8781-310e352cbdf3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20575, 626, 193, 4, 28, "Input",ExpressionUUID->"69f49ff9-e417-5f40-aeaa-cde257593c69"],
Cell[20771, 632, 1187, 32, 53, "Output",ExpressionUUID->"4c29179c-a03b-314a-ab90-fac7fe908389"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21995, 669, 195, 4, 28, "Input",ExpressionUUID->"5b65a73c-4e20-c742-b9f2-fcd063f2c2ce"],
Cell[22193, 675, 319, 4, 32, "Output",ExpressionUUID->"c451d916-cbde-6d4c-8e06-aa7632e88e18"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22549, 684, 195, 4, 28, "Input",ExpressionUUID->"63c22187-6a1e-7a49-aba3-25212eb88839"],
Cell[22747, 690, 319, 4, 32, "Output",ExpressionUUID->"43342e35-8eca-8d44-843b-c4944ffdbfaa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23103, 699, 315, 7, 28, "Input",ExpressionUUID->"f5a3b55e-e3f9-ec46-bb2d-a2e4f837855a"],
Cell[23421, 708, 1564, 43, 56, "Output",ExpressionUUID->"5e791f14-3628-c840-9d26-67c824d03db0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25022, 756, 235, 5, 28, "Input",ExpressionUUID->"e1ae5c23-652e-724c-9ada-3cc1194223b2"],
Cell[25260, 763, 313, 4, 32, "Output",ExpressionUUID->"e990d9d4-7ba3-2e4a-90f4-7349988ee597"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25610, 772, 237, 5, 28, "Input",ExpressionUUID->"6352e0aa-11cc-434c-bb09-5c1cc20a4ffd"],
Cell[25850, 779, 321, 4, 32, "Output",ExpressionUUID->"4abf4d8b-065d-934b-b2c9-1a24be40c0ca"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26208, 788, 288, 7, 28, "Input",ExpressionUUID->"f107e166-6cd9-464e-b7a4-0389d2d34972"],
Cell[26499, 797, 2281, 66, 56, "Output",ExpressionUUID->"ac902ac7-3f92-0542-8ac0-58b7440cd1fd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28817, 868, 193, 4, 28, "Input",ExpressionUUID->"c45a4a22-e098-1241-86e1-07802703052d"],
Cell[29013, 874, 991, 27, 49, "Output",ExpressionUUID->"a38318a5-be7a-0640-9793-6e17f2265a18"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30041, 906, 195, 4, 28, "Input",ExpressionUUID->"0d138635-0090-174d-815b-542bf2e0d8b5"],
Cell[30239, 912, 312, 4, 32, "Output",ExpressionUUID->"b171a312-2406-4e44-b07f-85064479f845"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30588, 921, 193, 4, 28, "Input",ExpressionUUID->"d3d2c617-cd76-da49-a607-2928471f9489"],
Cell[30784, 927, 1552, 43, 56, "Output",ExpressionUUID->"f35f45e7-d47f-7648-b7a6-ec95f1ca46a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32373, 975, 195, 4, 28, "Input",ExpressionUUID->"2f1a8c86-b3a2-d342-8bb5-6598276f92d9"],
Cell[32571, 981, 319, 4, 32, "Output",ExpressionUUID->"016bbc9d-bed3-bc46-87ef-9b4fc39e9dd7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32927, 990, 195, 4, 28, "Input",ExpressionUUID->"caac1b25-d9ce-834d-8f12-9deda92a459a"],
Cell[33125, 996, 318, 4, 32, "Output",ExpressionUUID->"0ffdcb27-65b6-1e4a-a073-3e2372f09321"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33480, 1005, 1501, 41, 48, "Input",ExpressionUUID->"e28adfce-ce47-2046-a1f6-b9e153246392"],
Cell[34984, 1048, 1389, 37, 51, "Output",ExpressionUUID->"cff4d5f9-0644-6f49-8638-267c64e73565"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36410, 1090, 1828, 51, 87, "Input",ExpressionUUID->"a26730d5-8c09-5440-95e3-bce0ec0567d2"],
Cell[38241, 1143, 1689, 46, 56, "Output",ExpressionUUID->"30848a4a-9787-9c46-a0db-dc7f35af5189"]
}, Open  ]],
Cell[CellGroupData[{
Cell[39967, 1194, 7430, 208, 358, "Input",ExpressionUUID->"ebdd3e99-f4d0-124a-9dca-6b385b8b06c2"],
Cell[47400, 1404, 6647, 173, 120, "Output",ExpressionUUID->"880f5c8f-f805-e24f-a1e3-9e24220704a7"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54084, 1582, 600, 17, 28, "Input",ExpressionUUID->"c8238ef6-1fbd-db45-b033-c465b50dd89a"],
Cell[54687, 1601, 1221, 37, 56, "Output",ExpressionUUID->"9918eb96-e3ea-7944-8607-c85182556397"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55945, 1643, 965, 24, 47, "Input",ExpressionUUID->"297dea56-ac21-b249-8f6a-ebd0e00873dd"],
Cell[56913, 1669, 1513, 47, 54, "Output",ExpressionUUID->"0d4b4243-79eb-f740-94bd-ea664381f811"]
}, Open  ]],
Cell[58441, 1719, 269, 5, 28, "Input",ExpressionUUID->"91d8950c-1517-2441-a740-2d7ab9377ce9"],
Cell[CellGroupData[{
Cell[58735, 1728, 506, 13, 28, "Input",ExpressionUUID->"378b8eee-0bbd-8843-84fa-c7d0d426dcf7"],
Cell[59244, 1743, 3086, 90, 77, "Output",ExpressionUUID->"15c274a4-85fb-894d-a1e9-c1354a48b468"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62367, 1838, 884, 24, 67, "Input",ExpressionUUID->"03046767-2cc8-6a43-8268-6d419f701000"],
Cell[63254, 1864, 189, 2, 32, "Output",ExpressionUUID->"468ea046-6006-ed40-a549-e5d6e3527027"]
}, Open  ]],
Cell[63458, 1869, 378, 7, 28, "Input",ExpressionUUID->"bdab453d-5880-5a4c-8429-ed5780015fd2"],
Cell[CellGroupData[{
Cell[63861, 1880, 3456, 97, 116, "Input",ExpressionUUID->"bb72b347-4758-2545-9ba5-17d7176112ca"],
Cell[67320, 1979, 239, 4, 32, "Output",ExpressionUUID->"11a4973a-cee7-9b4d-9195-1081fceb2571"]
}, Open  ]]
}
]
*)

